/*
 * Decompiled with CFR 0.152.
 */
package abilliontrillionstars.hextended.items;

import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.utils.MathUtils;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class ItemBatteryStaff
extends ItemStaff
implements MediaHolderItem {
    public static final long CAPACITY_IN_DUST = 30L;
    private static final DecimalFormat DUST_AMOUNT = new DecimalFormat("###,###.##");
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");

    public ItemBatteryStaff(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7843(class_1799 itemStack, class_1937 level, class_1657 player) {
        this.setMedia(itemStack, this.getMaxMedia(itemStack));
    }

    public long getMedia(class_1799 stack) {
        return NBTHelper.getInt((class_1799)stack, (String)"hexcasting:media");
    }

    public long getMaxMedia(class_1799 stack) {
        return 10000L * 30L;
    }

    public void setMedia(class_1799 stack, long media) {
        NBTHelper.putLong((class_1799)stack, (String)"hexcasting:media", (long)MathUtils.clamp((long)media, (long)0L, (long)this.getMaxMedia(stack)));
    }

    public boolean canProvideMedia(class_1799 stack) {
        return true;
    }

    public boolean canRecharge(class_1799 stack) {
        return false;
    }

    public float getMediaFullness(class_1799 stack) {
        long max = this.getMaxMedia(stack);
        if (max == 0L) {
            return 0.0f;
        }
        return (float)this.getMedia(stack) / (float)max;
    }

    public boolean method_31567(class_1799 stack) {
        return this.getMaxMedia(stack) > 0L;
    }

    public int method_31569(class_1799 pStack) {
        long media = this.getMedia(pStack);
        long maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarWidth((long)media, (long)maxMedia);
    }

    public int method_31571(class_1799 stack) {
        return MediaHelper.mediaBarColor((long)this.getMedia(stack), (long)this.getMaxMedia(stack));
    }

    public long withdrawMedia(class_1799 stack, long cost, boolean simulate) {
        long mediaHere = this.getMedia(stack);
        if (cost < 0L) {
            cost = mediaHere;
        }
        if (!simulate) {
            long mediaLeft = mediaHere - cost;
            this.setMedia(stack, mediaLeft);
            if (mediaLeft < 100L) {
                stack.method_7934(1);
            }
        }
        return Math.min(cost, mediaHere);
    }

    public static class_1799 withMedia(class_1799 stack, int media, int maxMedia) {
        class_1792 item = stack.method_7909();
        if (item instanceof ItemMediaHolder) {
            NBTHelper.putInt((class_1799)stack, (String)"hexcasting:media", (int)media);
            NBTHelper.putInt((class_1799)stack, (String)"hexcasting:start_media", (int)maxMedia);
        }
        return stack;
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        long maxMedia = this.getMaxMedia(pStack);
        if (maxMedia > 0L) {
            long media = this.getMedia(pStack);
            float fullness = this.getMediaFullness(pStack);
            class_5251 color = class_5251.method_27717((int)MediaHelper.mediaBarColor((long)media, (long)maxMedia));
            class_5250 mediamount = class_2561.method_43470((String)DUST_AMOUNT.format((float)media / 10000.0f));
            class_5250 percentFull = class_2561.method_43470((String)(PERCENTAGE.format(100.0f * fullness) + "%"));
            class_5250 maxCapacity = class_2561.method_43469((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format((float)maxMedia / 10000.0f)});
            mediamount.method_27694(style -> style.method_27703(ItemMediaHolder.HEX_COLOR));
            maxCapacity.method_27694(style -> style.method_27703(ItemMediaHolder.HEX_COLOR));
            percentFull.method_27694(style -> style.method_27703(color));
            pTooltipComponents.add((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.media_amount.advanced", (Object[])new Object[]{mediamount, maxCapacity, percentFull}));
        }
        super.method_7851(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

